﻿/* Skript zur Demonstration von Datumsbereichen
 * Als Benutzer SCOTT ausführen
 */
 
-- Erzeugung einer Beispieltabelle
create table time_range_test (
  id number,
  action varchar2(25 char),
  valid_from date,
  valid_to date);
  
insert into time_range_test
select 1, 'Start of project', to_date('15.02.2010 19:30:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('16.02.2010 09:30:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 1, 'Kick off', to_date('16.02.2010 09:31:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('16.02.2010 11:59:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 1, 'Phase 1', to_date('16.02.2010 12:00:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('03.03.2010 07:59:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 1, 'Phase 2', to_date('03.03.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('31.12.2099 00:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Start of project', to_date('19.02.2010 19:30:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('20.02.2010 09:30:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Kick off', to_date('20.02.2010 09:31:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('20.02.2010 11:59:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Phase 1', to_date('20.02.2010 12:00:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('01.03.2010 07:59:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Phase 2', to_date('01.03.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('31.12.2099 00:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Start of project', to_date('18.02.2010 19:30:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('19.02.2010 09:30:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Kick off', to_date('19.02.2010 09:31:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('19.02.2010 11:59:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Phase 1', to_date('19.02.2010 12:00:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('18.03.2010 07:59:59', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Phase 2', to_date('18.03.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss'), to_date('31.12.2099 00:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual;

commit;

select *
  from time_range_test;
  
-- Einfache Abfrage: Welches Projekt ist am 03.03. in Phase 2?
select to_char(id) id, action, valid_from, valid_to
  from time_range_test
 where to_date('03.03.2010', 'dd.mm.yyyy') between valid_from and valid_to
   and action = 'Phase 2';
   
-- Wie lange dauert Phase 1 im Schnitt?
select avg(valid_to - valid_from) dauer
  from time_range_test
 where action = 'Phase 1';
 
-- Ausgabe mit Intervall:
select numtodsinterval(avg(valid_to - valid_from), 'day') dauer
  from time_range_test
 where action = 'Phase 1';
 
-- Wieviele Tage der Phase 2 wurden im März geleistet?
select sum(least(m.month_end, t.valid_to) - greatest(m.month_start, t.valid_from)) days
  from time_range_test t
  join (select to_date('01.03.2010', 'dd.mm.yyyy') month_start,
               to_date('31.03.2010 23:59:59', 
                       'dd.mm.yyyy hh24:mi:ss') month_end
          from dual) m
    on valid_from <= month_end and valid_to >= month_start
 where t.action = 'Phase 2';
 
-- kleiner Trick: Abfrage zur virtuellen Erzeugung mehrere Monate
select add_months(
         to_date('01.01.2010', 'dd.mm.yyyy'), 
         rownum - 1) month_start,
       last_day(
         add_months(
           to_date('01.01.2010', 'dd.mm.yyyy'),
           rownum - 1))
       + interval '23:59:59' hour to second month_end
  from all_objects
 where rownum < 4;
 
-- Ausweitung der Abfrage auf mehrere Monate
-- Erstellung einer View mit Start- und Enddatum der benötigten Monate
create or replace view months as
select add_months(to_date('01.01.2010', 'dd.mm.yyyy'), rownum - 1) month_start,
       add_months(to_date('01.01.2010', 'dd.mm.yyyy'), rownum) - interval '1' second month_end
  from all_objects
 where rownum < 4;
 
-- Kontrollausgabe
select *
  from months;

-- Erweiterte Analyse
select month_start,
       round(sum(least(m.month_end, t.valid_to)
               - greatest(m.month_start, t.valid_from)), 1) days
  from time_range_test t
  join months m
    on valid_from <= month_end and valid_to >= month_start
 where t.action = 'Phase 1'
 group by month_start
 order by month_start desc;


-- Kontrollauswertung: Welche Intervalle gehen in welche Monate
select t.id, t.valid_from, t.valid_to,
       greatest(m.month_start, t.valid_from) interval_start,
       least(m.month_end, t.valid_to) interval_end
  from time_range_test t
  join months m
    on valid_from <= month_end and valid_to >= month_start
 where t.action = 'Phase 1'
 order by t.id, interval_start;
 
 
-- Verwendung des undokumentierten Operators OVERLAPS
select month_start,
       round(sum(least(m.month_end, t.valid_to)
               - greatest(m.month_start, t.valid_from)), 1) days
  from time_range_test t
  join months m
    on (valid_from, valid_to) overlaps (month_start, month_end)
 where t.action = 'Phase 1'
 group by month_start
 order by month_start desc;
 
-- Verwendung des Datentyps WM_PERIOD
create table emp_dept(
  empno number,
  deptno number,
  date_range wm_period);
  
insert into emp_dept
select empno, deptno, 
       wm_period(
         hiredate, 
         to_date('31.12.2999', 'dd.mm.yyyy'))
  from emp;

commit;
  
select e.empno, e.deptno, 
       e.date_range.validfrom, 
       e.date_range.validtill
  from emp_dept e;
  
-- Prüfung auf überlappende Interalle: Wer hat im Mai 1981 im Unternehmen gearbeitet?
select e.empno, e.deptno, e.date_range.validfrom
  from emp_dept e
 where wm_overlaps(date_range, wm_period(date '1981-05-01', date '1981-05-31')) = 1;
 

 
/* Ein alternatives Datenmodell */
create table time_point_test (
  id number,
  action varchar2(25 char),
  valid_from date,
  constraint pk_time_point_test
    primary key (id, valid_from));

insert into time_point_test
select 1, 'Start of project', to_date('15.02.2010 19:30:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 1, 'Kick off', to_date('16.02.2010 09:31:00', 'dd.mm.yyyy hh24:mi:ss')from dual union all
select 1, 'Phase 1', to_date('16.02.2010 12:00:00', 'dd.mm.yyyy hh24:mi:ss')from dual union all
select 1, 'Phase 2', to_date('03.03.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 1, 'End of project', to_date('19.04.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Start of project', to_date('19.02.2010 19:30:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Kick off', to_date('20.02.2010 09:31:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Phase 1', to_date('20.02.2010 12:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 2, 'Phase 2', to_date('01.03.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Start of project', to_date('18.02.2010 19:30:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Kick off', to_date('19.02.2010 09:31:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Phase 1', to_date('19.02.2010 12:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'Phase 2', to_date('18.03.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual union all
select 3, 'End of project', to_date('07.04.2010 08:00:00', 'dd.mm.yyyy hh24:mi:ss') from dual;

commit;

-- Kontrollausgabe:
select id, action, valid_from
  from time_point_test
 order by id, valid_from;
 
-- Ausgabe von Start- und Enddatum der Phasen
select id, action, valid_from,
       nvl(
         lead(valid_from) over
           (partition by id order by valid_from) - 
              interval '1' second,
         to_date('31.12.2099', 'dd.mm.yyyy')) valid_to
  from time_point_test;
  

